/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global beforeEach: false, afterEach: false, it: false, describe: false, expect: false */

var sinon = require("sinon"),
    Q = require("q"),
    FS = require("fs"),
    StringUtils = require("../StringUtils");

describe("StringUtils", function () {
    "use strict";

    var sandbox = sinon.sandbox.create();

    afterEach(function () {
        sandbox.restore();
    });

    describe("escaping", function () {
        it("escapes backslashes", function () {
            expect(StringUtils.escapeBackslashes("Hello\\Back\\slashes")).to.equal("Hello\\\\Back\\\\slashes");
        });

        it("escapes double quotes", function () {
            expect(StringUtils.escapeDoubleQuotes('Hello"Double"Quotes')).to.equal('Hello\\"Double\\"Quotes');
        });

        it("escapes single quotes", function () {
            expect(StringUtils.escapeSingleQuotes("Hello'Single'Quotes")).to.equal("Hello\\'Single\\'Quotes");
        });

        it("escapes strings for a code context", function () {
            expect(StringUtils.escapeForCodeContext("Str\"ing\\ for' code\"\\\' context'"))
                .to.equal("Str\\\"ing\\\\ for\\' code\\\"\\\\\\' context\\'");
        });
    }); // escaping

    describe("encoding", function () {
        it("replaces commas in string", function () {
            var val = "string, with, commas",
                expRes = "string&#44 with&#44 commas";
            expect(StringUtils.encodeCommas(val)).to.equal(expRes);
        });
        
        it("doesn't change string without commas", function () {
            var val = "string without commas",
                expRes = val;
            expect(StringUtils.encodeCommas(val)).to.equal(expRes);
        });
        
        it("doesn't change value that isn't a string", function () {
            var val = 42,
                expRes = val;
            expect(StringUtils.encodeCommas(val)).to.equal(expRes);
        });
        
    }); // encoding
});
